function [data]=STM32F103_CC_SETUP_B3(skt)
% uses DMA 7, Timer 2, CC2, iopin B3
if (size(findname(skt.name,"CC_Fest"))>0)
   f=udpget(skt,"CC_Fest");
else
 STM32F103_bitfields; % Get some bitfields

% Read Core Clock rate from registry
 FT_Clock=udpget(skt,"SystemCoreClock");


%Set up DMA1 Channel7
%udp_bit_set(skt,"RCC_AHBENR",DMA1EN); % DMA clock is on
 udp_bit_clear(skt,"DMA1_C7_CCR",EN);
 DMA_CLEAR_VAL =sum([  PL*3  MSIZE*3 PSIZE*3 MINC PINC CIRC DIR TEIE  HTIE TCIE  EN]);
 udp_bit_clear(skt,"DMA1_C7_CCR",DMA_CLEAR_VAL);
 DMA_SET_VAL =sum([  PL*0  MSIZE*1 PSIZE*1 MINC  CIRC  ]);
 udp_bit_set(skt,"DMA1_C7_CCR",DMA_SET_VAL);
 udpset(skt,"DMA1_C7_CMAR",skt.ptr(skt_find_index(skt,"CC_DMA_Buffer")));
 udpset(skt,"DMA1_C7_CPAR",skt.ptr(skt_find_index(skt,"TIM2_CCR2")));
 int2send=floor(skt.len(skt_find_index(skt,"CC_DMA_Buffer"))/2); % Debug

 udpset(skt,"DMA1_C7_CNDTR",int2send);


%Set up Timer 2 to drive CC
 udp_bit_set(skt,"RCC_APB1ENR",TIM2EN); % TIMER2 clock is on
 udpset(skt,"TIM2_CR1",0);           %Clear TIM2_CR1
 udpset(skt,"TIM2_CR2",0);           %Clear TIM2_CR1

 udp_bit_set(skt,"TIM2_CR1",ARPE+URS);%configure TIM2_CR1
 udpset(skt,"TIM2_CR2",2*MMS);%configure the timer event = reload

 udpset(skt,'TIM2_CCER',CC2E);


 udpset(skt,"TIM2_PSC",0);%configure the timer prescaler
 udpset(skt,"TIM2_ARR",65535);%configure the timer reload (period) register
 udp_bit_set(skt,"TIM2_EGR",CC2G+TG);
 udp_bit_set(skt,"TIM2_DIER",CC2DE);


% Let rip
 udp_bit_set(skt,"DMA1_C7_CCR",EN);     % Tell DMA to go
 udpset(skt,'TIM2_CR1',CEN);
end
endfunction



